/**
 * 
 */
package gov.va.med.mhv.usermgmt.service;

import java.util.Calendar;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.core.util.TimestampUtils;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.transfer.UserProfileDeactivationAudit;
import gov.va.med.mhv.usermgmt.transfer.UserProfileDeactivationReason;
import gov.va.med.mhv.usermgmt.util.UserProfileActivationStateUtils;
import gov.va.med.mhv.usermgmt.util.UserProfileDeactivationUtils;


/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class TestUserProfileDeactivationAudit extends UserProfileTestCase {
    

    private static final Log LOG = LogFactory.getLog(
        TestUserProfileDeactivationAudit.class);

    public void testStandardDeactivationReasons() throws Exception {
        assertNotNull(UserProfileDeactivationUtils.MULTIPLE_ACCOUNTS_RESOLUTION);
    }


    private UserProfileDeactivationAudit createAudit(UserProfile userProfile,
        UserProfileDeactivationReason reason, String changedBy, String notes) 
    {
        UserProfileDeactivationAudit audit = TransferObjectFactory.
        createUserProfileDeactivationAudit();
        audit.setAction((reason != null) 
            ? UserProfileActivationStateUtils.DEACTIVATED
            : UserProfileActivationStateUtils.ACTIVATED);
        audit.setUserProfile(userProfile);
        audit.setDeactivationReason(reason);
        audit.setChangeDate(TimestampUtils.createCurrentTime());
        audit.setChangedBy(changedBy);
        audit.setNotes(notes);
        return audit;
    }

    private void deleteAudit(UserProfileDeactivationAudit audit) {
        if (audit == null) {
            return;
        }
        UserProfileDeactivationAuditServiceResponse response = 
            ServiceDelegateFactory.createEntityMaintenanceServiceDelegate().
            delete(audit.getUserProfileDeactivationAuditPK());
        if (hasErrors(response)) {
            logMessages(response, audit.getClass(), LOG);
        }
    }

}
